/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.coprocess;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.coprocess.CoProcess;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;

public class CoProcessManager {
    private static final List<CoProcess> coProcesses = new ArrayList<CoProcess>();
    private static final AtomicBoolean started;

    public static void start() {
        if (started.getAndSet(true)) {
            return;
        }
        for (CoProcess coProcess : coProcesses) {
            coProcess.start();
        }
    }

    public static void stop() {
        if (!started.getAndSet(false)) {
            return;
        }
        Iterator<CoProcess> iter = coProcesses.iterator();
        while (iter.hasNext()) {
            CoProcess coProcess = iter.next();
            coProcess.stop();
            if (coProcess instanceof Closeable) {
                Closeable cl = (Closeable)((Object)coProcess);
                try {
                    cl.close();
                }
                catch (IOException e) {
                    LibJf.LOGGER.error("Could not close co-process", e);
                }
            }
            iter.remove();
        }
    }

    static {
        coProcesses.addAll(FabricLoader.getInstance().getEntrypoints("libjf:coprocess", CoProcess.class));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            ServerLifecycleEvents.SERVER_STOPPED.register(server -> CoProcessManager.stop());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(CoProcessManager::stop));
        started = new AtomicBoolean(false);
    }
}

